
## Role : BQuery support

Indexer: this maintains a BFS-like attribute index, and provides field-expedient support for BQuery.
This is a VFS plug-in which sits on top of another one (typically NTFS-3g)
and snoops on file operations directed to that underlying FS, looking for ops...
1) related to xattr
2) related to *writing* (or deleting) them rather than reading them,
and maintains an index as a 'hidden file'.

That index can then be queried, speaking a "protocol" common to our re-implementation of BQuery.

Implementation:
This uses "pure" Genode code, without dependancies on libc.lib.so or haiku.lib.so,
so that we may live in a vfs_server and not just in an app's VFS.

Read on for implementation overview:

## vfs_indexer.cpp

The actual VFS plug-in that interfaces with Genode's vfs system, and "maps"
file system requests to IndexStore operations.

## class BufIO

A data buffer that can hold a nul-terminated string (as Haiku's BString does) and is used
as such for holding the (textual) Index ;
and it may also hold binary data (as Haiku's BMallocIO) and is used as such for query results,
which contain several embedded '\0' characters to delimitate result entries.

## class IndexStore

Provides hooks called by the VFS plug-in, which then call appropriate actions in SlotIO.

## class SlotIO

Applies a certain (textual) format to the master Index.
Can lookup a slot by file path, or iterate over the whole set, providing their attributes for matching purposes.

## class SlotItem

Assists SlotIO in making changes to the Index: generally, an index entry (slot) is parsed into a
SlotItem (and removed from the master Index), modified, and then re-inserted at the end of the Index.

This happens to be the more complex class of the lot, because it handles not only the _Index maintenance_
role, but also the _Index querying_ role, meaning it must be able to parse "query predicates" which include
kinda-regular-expressions like e.g.:

```
(Audio:Artist=="Pink*Floyd")
```

## Overview diagram

Once the attribute *indexer* is integrated into a full-fledged system, we get the following fairly deeply-layered structure ;
arrows are labelled when they are on transit routes for file paths that
include "dot paths" (ioctl-like extended attributes access) like "/boot/Music/thewall.mp3/.xattrs":

~~~ pikchr

down
"App"

arrow
SKit: box "Storage Kit" "(produces dot-paths)" fit

move right from last box.e
move down
LibC: oval "libc" fit
arrow from SKit.se to LibC.nw  "dot-paths" aligned below

#+ add "Media Kit" box above the libav one...

move right from LibC.e
move up
LibAV: oval  "libav" "audio playback" fit
arrow <- from LibC.ne to LibAV.sw

move down to LibC.s
arrow  "dot-paths" aligned below

Vfs: oval "vfs" fit
move left from Vfs.w
move down
#arrow  "dot-paths" aligned below
#arrow from LibC.s

Idx: box "indexer" bold "plug-in" "(snoops on dot-paths)" fit thick fill Bisque
arrow  <-  from Idx.n to Vfs.s  "dot-paths" aligned below

move right from Vfs.e
move down

Ntfs: oval "FUSe NTFS" "plug-in" "(knows dot-paths)" fit
line from Vfs.s to Ntfs.n

arrow from Idx.e to Ntfs.w "dot" "paths"

#arrow
move to Ntfs.s
arrow

oval "lib-ntfs-3g" fit
arrow "via" aligned "libc" aligned

oval "Block dev" fit
arrow

oval "ahci" fit

~~~



