#ifndef BufIO_H
#define BufIO_H
/*
 * Copyright 2022, ttcoder
 * All rights reserved. Distributed under the terms of the MIT license.
 */

// base.a
#include <base/allocator.h>  // member



class PickStr
{
	// Pick a sub-string of known length from a *non-nul-terminated* byte stream.
	
public:
		PickStr( const char * str, unsigned numchars );
		
		const char * string() const;
		unsigned length() const;

private:
		char _buf[512];
};



class BufIO
{
	// A data buffer not unlike Haiku's BMallocIO
	// Used...
	// - to hold query results in IndexStore
	// - as base class for SlotIO
	
public:

		BufIO( Genode::Allocator & alloc );
		~BufIO();
		
		void Dump();
		const void * Buffer() const;
		unsigned BufferLength() const;
		
		void Clear();
		void AppendStr( const char * string );
		void Append( const void * buf, unsigned size );
		void Erase( unsigned where, unsigned delta );


protected:  // Data

		void * bufData;
		unsigned bufSize;
		
		Genode::Allocator & heapAlloc;
};


#endif // BufIO_H

