#ifndef broker_session_connection_H
#define broker_session_connection_H
/*
 * Copyright 2022, ttcoder
 * All rights reserved. Distributed under the terms of the MIT license.
 */


// genode/base
#include <base/connection.h>

// project
#include <broker_session/client.h>

namespace bro_conn {
	struct Connection;
}


struct bro_conn::Connection : Genode::Connection<Session>, Session_client
{
	Connection( Genode::Env &env )
	:	Genode::Connection<bro_conn::Session>(  // create session
			env,
			Label(),
			Ram_quota { 6*1024 } ,
			Args() )
		,Session_client( cap() )  // initialize RPC interface
	{
	}
};


#endif // broker_session_connection_H

