#ifndef broker_session_client_H
#define broker_session_client_H
/*
 * Copyright 2022, ttcoder
 * All rights reserved. Distributed under the terms of the MIT license.
 */


// genode/base
#include <base/rpc_client.h>

// project
#include <broker_session/broker_session.h>

namespace bro_conn {
	struct Session_client;
}


struct bro_conn::Session_client : Genode::Rpc_client<Session>
{
	Session_client( Genode::Capability<Session> cap )
	:	Genode::Rpc_client<Session>( cap )
	{
	}
	
	
	// Override in bro_conn::Session...
	
	PseudoTeam  id_for_team() override
	{
		return call<Rpc_id_for_team>();
	}
	Path  pipe_for_team() override
	{
		return call<Rpc_pipe_for_team>();
	}
	void  port_created( int port, Name name ) override
	{
		call<Rpc_port_created>( port, name );
	}
	int  find_port( Name by_name ) override
	{
		return call<Rpc_find_port>( by_name );
	}
	int  writeport_header( long discriminant, int port, int code, int overall_size ) override
	{
		return call<Rpc_writeport_header>( discriminant, port, code, overall_size );
	}
	int  writeport_chunk( long discriminant, int port, BufData buf, int chunk_size ) override
	{
		return call<Rpc_writeport_chunk>( discriminant, port, buf, chunk_size );
	}
	void  port_deleted( int port ) override
	{
		call<Rpc_port_deleted>( port );
	}
};


#endif // broker_session_client_H

