#ifndef broker_session_H
#define broker_session_H
/*
 * Copyright 2022, ttcoder
 * All rights reserved. Distributed under the terms of the MIT license.
 */


// genode/base
#include <session/session.h>
#include <base/rpc.h>

namespace bro_conn {
	struct Session;
}


struct bro_conn::Session : Genode::Session
{
	// Genode::Session... (or are these _template_ expectations/params ?)
	//
	
	static const char * service_name()
	{
		return "Hai_Broker";
	}
	enum { CAP_QUOTA = 2 };
	
	
	// New Types
	//
	
	typedef Genode::String<32> Name;  // port names, B_OS_NAME_LENGTH (32 bytes)
	typedef Genode::String<64> Path;  // pipe file paths (typically short)
	typedef int PseudoTeam;  // aka "Group" or "Process", since this is not a real team_t ...
	//+ typedef int PortWithEmbeddedPseudoTeamNum....
	struct BufData {  //xx rename to "Chunk"
		// if the message payload does not fit in one buffer,
		// writeport_chunk() is called as many times as necessary with each "chunk"
		char buf[64];
			// TESTS: use this buffer size for stress-testing of the 'chunk' code:
			//char buf[4];
	};
	
	
	// New Hooks
	//
	
	virtual PseudoTeam id_for_team() = 0;
	virtual Path pipe_for_team() = 0;
	virtual void port_created( int port, Name name ) = 0;
	virtual int  find_port( Name by_name ) = 0;
//	virtual int write_port( int port, int code, BufData buf, int size ) = 0;
	virtual int  writeport_header( long discriminant, int port, int code, int complete_size ) = 0;
	virtual int  writeport_chunk(  long discriminant, int port, BufData buf, int chunk_size ) = 0;
	virtual void port_deleted( int port ) = 0;
	
	// RPC Interface
	//
	
	GENODE_RPC( Rpc_id_for_team,   int, id_for_team );
	GENODE_RPC( Rpc_pipe_for_team, Path, pipe_for_team );
	GENODE_RPC( Rpc_port_created,  void, port_created, int, Name );
	GENODE_RPC( Rpc_find_port, int, find_port, Name );
	GENODE_RPC( Rpc_writeport_header, int, writeport_header, long, int, int, int );
	GENODE_RPC( Rpc_writeport_chunk,  int, writeport_chunk,  long, int, BufData, int );
	GENODE_RPC( Rpc_port_deleted, void, port_deleted, int );

	GENODE_RPC_INTERFACE(
		Rpc_id_for_team
		,Rpc_pipe_for_team
		,Rpc_port_created
		,Rpc_find_port
		,Rpc_writeport_header
		,Rpc_writeport_chunk
		,Rpc_port_deleted
		);
};


#endif // broker_session_H
