#ifndef RemoteBroker_H
#define RemoteBroker_H
/*
 * Copyright 2022, ttcoder
 * All rights reserved. Distributed under the terms of the MIT license.
 */


// project
#include <broker_session/connection.h>  // member


class Remote
{
	// AKA: GeRemoteBrokerConnection, aka ClientOfBroker
	//
	// A thin layer on top of class bro_conn::Connection ;
	// we used to implement it with two-way pipes instead of
	// an RPC/inbound-pipes combination, so this refactoring might make sense...
	
public:

	Remote( Genode::Env & env );
	
	void EnsureInitialized();
	
	team_id PseudoTeam() const;
	int PortNumberingBase() const;
	
	void NotifyPortCreated( port_id id, const char * name );
	port_id FindPort( const char * name );
	status_t WritePort(
		port_id port,
		int32 code,
		const void * buffer,
		size_t size
		);

private:  // Code

	void ctorInit();
	void lazyInit();//void openPipes();
#if 0
	void StartMessage( int32 code );
	void appendString32( const char * str );
	status_t Flush();
	int32 SyncReadInt32();
#endif


private:  // Data

#if 0
	// I/O: buf
	BNetBuffer outBuf;
	
	// I/O: file descriptors
	int tx;  // FD to "first-leg" pipe, to Tx data to Broker
	int rx;  // FD to "second-leg" pipe, to Rx data from Broker
#else
	// RPC session
	bro_conn::Connection brokerConn;
#endif
	
	// State
	int numberingBase_Team;  // starts at 1 (for pseudo "team 1") and counts up; used to build port numbers like "1001", "1002" and so on.
};


#endif // RemoteBroker_H

