
## Role : BMessenger and write_port() support

### Test with:

	jam hog-broker.emu6

## About

This component is a messaging 'broker', aka 'Haiku_kernel_ports_emulator' (for the IPC case, not the "local ports" case)

The **Broker**, aka **"kernel_server"** aka **"kernel_ports_manager"**, aka **"ports_ipc_transport_server"**,
provides the upper half of support for the Haiku ports API (syscalls like
write_port(), read_port(), find_port() and so on).
Specifically, it provides the inter-component (IPC) part,
by opposed to the "local" basic port support provided by the api_public_port_etc.cpp file.

Only 'toy' Haiku apps can work in complete isolation. Serious Haiku-on-Genode scenarios
(and especially full-fledged "Desktop" scenarios involving Tracker and Deskbar)
require IPC communication, which in Haiku requires global (not just local) **ports** for communication
between clients (applications) and servers like **registrar** (also called **roster**),
which cannot work without such ports.


## Implementation

Broker advertises the Genode-style "Hai_Broker" service, which works with:

- Genode RPC calls, for much of the features, initiated from 'sender' clients to the Broker server.
- posix **pipes** (thanks to vfs_pipe.lib.so) for transporting write_port()ed data,
specifically the second half of the data's journey (from broker to recipient client)
after it has reached broker on the first leg of the journey  (from sender client to broker) via RPC calls.

Client apps call this Broker via 'glue' code which makes RPC calls to us to initiate transport,
and open()s read-only the inbound data pipe for reading inbound transported data
(that same pipe is opened write-only on Broker's side).


## Diagram

~~~ pikchr
# Client: Deskbar
Deskbar: oval "Sender app" fit

# Server: Broker
move up right from Deskbar.e
Broker: box "Broker" "1: responds to RPC" "2: write()s to pipe" fit
arrow  from Deskbar.ne to Broker.sw  "RPC" aligned "call" aligned

# Client: Tracker
move down right from Broker.e
Roster: oval "Recipient app" fit
arrow   <- from Broker.se to Roster.nw  "read()" aligned "pipe" aligned

# the "aligned" attribute means the arrow label is *rotated* (tilted) to be parallel to the arrow
~~~




## Haiku implementation

This is a general outline of what typically happens in Haiku during IPC, useful to keep in mind when debugging.

Implementation of roster registration on BApplication instantiation:

- BApplication makes sure BRoster is initialized.
- BRoster::_InitMessenger() calls find_port(B_REGISTRAR_PORT_NAME).
- BApplication::_InitData() calls BRoster::Private().AddApplication( signature-of-this-app, port, ... )
- the Registrar/Roster then memorizes the app info (signature, port, etc), so it can hand it out to future B_REG_GET_APP_INFO requests.

Implementation of BMessenger-to-app-signature, for sending BMessages to arbitrary apps:

- BMessenger::_InitData() first attempts to call BLaunchRoster()
(a misleading name for a class that talks to the launch_daemon, NOT the registrar/roster), which fails as we don't use the launch_daemon.
- BMessenger::_InitData() then calls be_roster->GetAppInfo(signature, &info).
- BRoster::GetAppInfo() can provide info.port by doing a synchronous B_REG_GET_APP_INFO request to the Registrar/Roster.
- BMessenger then sets fPort = info.port and is then ready to SendMessage() to the target app.

Generally speaking, to get a quick picture of what Haiku needs for the registrar to work, run this:

> grep -r B_REGISTRAR_PORT_NAME

which will highlight parts of the Haiku code where ports are used for/by the registrar.


## Notes

Haiku-o-g apps will detect when Broker is not running,
the glue code will try to run in degraded (local-only ports) mode.
If you want inter-apps IPC, including use of the so-called registrar,
then Broker's presence is needed.


