/*
** Copyright 2004, Axel Dörfler, axeld@pinc-software.de. All rights reserved.
** Distributed under the terms of the Haiku License.
*/


#include <fs_info.h>

#include <stdlib.h>
#include <fcntl.h>
#include <errno.h>

#ifndef HoG_GENODE
#include <errno_private.h>
#include <syscalls.h>
#endif  // ~not-HoG_GENODE


#ifndef HoG_GENODE

#define RETURN_AND_SET_ERRNO(status) \
	{ \
		if (status < 0) { \
			__set_errno(status); \
			return -1; \
		} \
		return status; \
	}

#else

#	include <stdio.h>  // printf()
#	include <string.h>  // memcmp()
///ToDo: *BVolume & friends* : for now we hardcode/hack "/boot" volume at dev_t device "0" -> should implement for real!
#	define DEV_ID_FOR_BOOT_VOLUME (0)

/**************/
static int debug = 0;

#endif  // ~not-HoG_GENODE


dev_t
dev_for_path(const char *path)
{
	struct stat stat;
///later: why pass "traverse=true" in dev_for_path() here: ?
	int status = _kern_read_stat(-1, path, true, &stat, sizeof(struct stat));
	if (status == B_OK)
		return stat.st_dev;

#ifndef HoG_GENODE
	RETURN_AND_SET_ERRNO(status);
#else
	return status; ///ToDo: we're returning a signed status_t into an (unsigned) BSD uint64, ouch -- see comments in basic-tests
#endif
}


dev_t
next_dev(int32 *_cookie)
{
#ifndef HoG_GENODE
	return _kern_next_device(_cookie);
		// For some reason, this one returns its error code directly

#else  // HoG_GENODE

	if( debug )
		printf(" next_dev(%d)\n", *_cookie );
	
	if( !_cookie || *_cookie != 0 )
		return -1;
	
	*_cookie += 1;
	return DEV_ID_FOR_BOOT_VOLUME;
#endif  // ~not-HoG_GENODE
}



int
fs_stat_dev(dev_t device, fs_info *info)
{
#ifndef HoG_GENODE
	status_t status = _kern_read_fs_info(device, info);

	RETURN_AND_SET_ERRNO(status);

#else  // HoG_GENODE

	// We don't have _kern_read_fs_info(), so implement a "good enough" substitute:
	
	if( debug )
		printf( " fs_stat_dev(%d ..)\n", device );
	
	if( device != DEV_ID_FOR_BOOT_VOLUME )
		return B_ERROR;
	
	errno = 0;
	
	fs_info model = {
		.dev = DEV_ID_FOR_BOOT_VOLUME,
		.root = 1,///are we sure the rootdir inode will always be '1' ?
//we can hardcode these for /boot
///later: should find a way to retrieve actual underlying FS specs (is it NTFS? is it ram-disk?)
		.flags = /*B_FS_IS_READONLY | */B_FS_HAS_QUERY | B_FS_IS_PERSISTENT | B_FS_HAS_MIME | B_FS_HAS_ATTR,
		.block_size = 512,
		.io_size = 512,
		.total_blocks = 999,
		. free_blocks = 0,
		.total_nodes = 0,
		.free_nodes = 0,
		.device_name = "unknown_device_fs",
		.volume_name = "boot",//that should be something like "System" or "RadioFiles" or at least "Haiku(OnGenode)"
		.fsh_name = "unknown_fs_handler"
	};
	*info = model;
	
	return 0;
#endif  // ~HoG_GENODE
}


