/*
 * Copyright 2023, ttcoder
 * All rights reserved. Distributed under the terms of the MIT license.
 */

// libc.lib.so
#include <stdio.h>

// haiku.lib.so
#include <RosterPrivate.h>  // for load_image()


/**************/
//static int debug = 1;



extern "C" {

int load_image( int argc, const char * const * argv, void*environ )
{
	// aka: load_image__client-side()
	// variant that talks to Registrar
	
	//if( debug )
	//	printf(" load_image(argc: %d  argv[0] <%s>)\n", argc, argv ? argv[0] : "no-argv" );
	
	if( argc < 1 )// || environ == NULL)
		return B_BAD_VALUE;
	
	BRoster roster;
	BRoster::Private roster_private( roster );
	status_t error = roster_private.RemoteLaunchInRegistrar( argc, argv );
	if( error != B_OK )
		fprintf( stderr, " load_image: RemoteLaunch failed: %s\n", strerror(error) );
	
	///ToDo: we're supposed to return a *thread_id* here, but instead we return B_OK/0, which requires work-arounds downstream (in Roster.cpp e.g.)
	return error;
}

}  // extern "C"



//#pragma mark - other functions which are supposed to be located here :

//load_add_on()
//unload_add_on()


