
#if 0  // not HoG_GENODE
#include <BeOSBuildCompatibility.h>
#endif  // ~not HoG_GENODE
#include <base/log.h>
#include <base/sleep.h>  // sleep_forever()


#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/time.h>

#include <Debug.h>
#include <image.h>
#include <OS.h>

mode_t __gUmask = 022;

// debugger
void
debugger(const char *message)
{
	fprintf(stderr, "debugger() called: %s\n", message);
#ifndef HoG_GENODE
	exit(1);
#else
	Genode::error( "sleeping forever -- back-call: ", __builtin_return_address(0) );
	// exit() crashes, I must be doing something wrong with LibC ; so use this instead:
	Genode::sleep_forever();
#endif
}

#if 0  // HoG_GENODE
///ToDo: debugger(): is it ok as-is, or needs urgent fix ?
///  instead of exit(1) above, use Genode::sleep_forever(); as in (wrong-named) Debug.cpp ?
///  -- anyway, these definitions should not be here, Haiku propoer has a "system/libroot/os/debug.c" file, might be a better fit.
///  or should we favor the below instead of my "pseudo kernel" impl ?
#endif  // ~HoG_GENODE


// _debuggerAssert
int
_debuggerAssert(const char *file, int line, const char *expression)
{
	char buffer[2048];
	snprintf(buffer, sizeof(buffer), "%s:%d: %s\n", file, line, expression);
	debugger(buffer);
	return 0;
}


#ifndef HoG_GENODE

#ifndef HAIKU_HOST_PLATFORM_HAIKU
// system_time
bigtime_t
system_time(void)
{
	struct timeval tm;
	gettimeofday(&tm, NULL);
	return (int64)tm.tv_sec * 1000000LL + (int64)tm.tv_usec;
}
#endif

// snooze
status_t
snooze(bigtime_t amount)
{
	if (amount <= 0)
		return B_OK;

	int64 secs = amount / 1000000LL;
	int64 usecs = amount % 1000000LL;
	if (secs > 0) {
		if (sleep((unsigned)secs) < 0)
			return errno;
	}

	if (usecs > 0) {
		if (usleep((useconds_t)usecs) < 0)
			return errno;
	}

	return B_OK;
}

// snooze_until
status_t
snooze_until(bigtime_t time, int timeBase)
{
	return snooze(time - system_time());
}

#endif  // ~HoG_GENODE

