
# Contents

Dir contents : in upstream, much of this is labelled "Kernel Kit" (and the headers are located in haiku/headers/os/kernel) but it is in fact not implemented in libbe.so like a "kit" would be, but is located in libroot.so instead. Not that this nuance changes things much for us, since we go for all-in-one library anyway.

I'm not sure of the layout yet, hence stuffing the files inside an "interim" subfolder for now. (interim/ contains stuff from haiku/headers/os/kernel and haiku/headers/private/libroot)

That's in contrast to librootbuild-variant/ which is a somewhat well-established part of the source,
for working with files and their attributes on top of a non-Haiku kernel.


# File basics

We mainly deal with compatibility issues entailed by using the upstream Storage Kit within Genode.

## Issue with entry_ref

One compatibility issue is the use of entry_ref's (a file denomination that only the upstream kernel and VFS know about, which does not seem to be used by any other operating system).
That problem is handled by librootbuild-variant/ which has special book-keeping code to map file descriptors to file paths and vice versa.
They use that code upstream, when they compile "host" tools (command-line tools destined to run e.g. Storage Kit code natively within BSD, Linux, etc) used for cross-compiling/building.
We re-use that code -- with a few changes -- in this project.

## Issue with stat()

Genode's VFS implementation leads stat() to return a different device ID for a hierarchy's root, compared to its children.
For instance, let's say you're configuring VFS with "/boot" 'mount'. Any child created below, e.g. "/boot/Music" will have a different device number as returned in the 'struct stat'.

This is a big no-no : BeOS-style OSes needs the device to be the same for the root and for its children, otherwise nothing works in the Storage Kit.
Absent the ability to fix stat()ing itself, we need a downstream fix (though maybe a tweak is possible in the
latter, i.e. maybe there's a way in vfs to make children 'adopt' the stat dev_id from the parent, i.e. /boot ?).

The 'fix' cannot be done in libc's stat() or in VFS, as we want to avoid patching Genode's code. What was done instead, is to find all/most-of the libroot code paths that rely on stat (fortunately, they mainly indirect through fs.cpp), and fix-up the stat struct there. Hence the FixUp_stat() function in librootbuild-variant/fs.cpp, and a dozen calls to it. That function sets everyone in the /boot hierarchy to arbitrary device number "0".


# File Attributes

Extended attributes are normally not part of Genode's VFS, but they
are handled in librootbuild-variant/ as a mix of BSD and Linux-style xattr.
The plan used to be: implement them with ioctl-style calls that would go through the VFS layers.
But ioctl() has a long, hackish, convoluted history, and that is (rightfully) frowned upon in Genode.

So instead of an ioctl lingo, we use dot-style semi "hidden" paths, which go through Genode's VFS sans problem.
For instance, when a BeOS-style program calls method BFile::ReadAttrString()
to access attribute "Audio:Artist" of file "TheWall.mp3", our compatibility layer translates that under-the-hood
into the following path:

	/boot/Music/PinkFloyd/.TheWall.mp3/attr/user.haiku.Audio:Artist

Which is simple enough.
The only obstacle to that is, BFile does not know the file's path, since it deals with file descriptors.
But that's solved with a simple two-liner patch to Genode libc's vfs_plugin.cc file,
as provided in this repository's Wiki (also see ticket #4346).

The final recipient must be able to "parse" such magic-dot-paths and respond to them.
Such is the case for our (patched-from-Genode) FUSE-NTFS-3g driver located in ge-drivers/.

The dot-path calls are placed in BSD-style functions, patched for Linux-style xattr
behavior, since Genode's FreeBSD headers provide prototypes for said functions ;
though on second thought we could also have ignored that and gone straight for xattr (?)

