/*
 * Copyright 2002-2015, Haiku Inc. All Rights Reserved.
 * Distributed under the terms of the MIT License.
 */
#ifndef _FIND_DIRECTORY_H
#define _FIND_DIRECTORY_H


#include <image.h>


typedef enum {
	/* Per volume directories */
	B_DESKTOP_DIRECTORY					= 0,
	B_TRASH_DIRECTORY,

	/* System directories */
	B_SYSTEM_DIRECTORY					= 1000,
	B_SYSTEM_ADDONS_DIRECTORY			= 1002,
	B_SYSTEM_BOOT_DIRECTORY,
	B_SYSTEM_FONTS_DIRECTORY,
	B_SYSTEM_LIB_DIRECTORY,
	B_SYSTEM_SERVERS_DIRECTORY,
	B_SYSTEM_APPS_DIRECTORY,
	B_SYSTEM_BIN_DIRECTORY,
	B_SYSTEM_DOCUMENTATION_DIRECTORY	= 1010,
	B_SYSTEM_PREFERENCES_DIRECTORY,
	B_SYSTEM_TRANSLATORS_DIRECTORY,
	B_SYSTEM_MEDIA_NODES_DIRECTORY,
	B_SYSTEM_SOUNDS_DIRECTORY,
	B_SYSTEM_DATA_DIRECTORY,
	B_SYSTEM_DEVELOP_DIRECTORY,
	B_SYSTEM_PACKAGES_DIRECTORY,
	B_SYSTEM_HEADERS_DIRECTORY,

	B_SYSTEM_ETC_DIRECTORY				= 2008,
	B_SYSTEM_SETTINGS_DIRECTORY			= 2010,
	B_SYSTEM_LOG_DIRECTORY				= 2012,
	B_SYSTEM_SPOOL_DIRECTORY,
	B_SYSTEM_TEMP_DIRECTORY,
	B_SYSTEM_VAR_DIRECTORY,
	B_SYSTEM_CACHE_DIRECTORY			= 2020,

	B_SYSTEM_NONPACKAGED_DIRECTORY		= 2023,
	B_SYSTEM_NONPACKAGED_ADDONS_DIRECTORY,
	B_SYSTEM_NONPACKAGED_TRANSLATORS_DIRECTORY,
	B_SYSTEM_NONPACKAGED_MEDIA_NODES_DIRECTORY,
	B_SYSTEM_NONPACKAGED_BIN_DIRECTORY,
	B_SYSTEM_NONPACKAGED_DATA_DIRECTORY,
	B_SYSTEM_NONPACKAGED_FONTS_DIRECTORY,
	B_SYSTEM_NONPACKAGED_SOUNDS_DIRECTORY,
	B_SYSTEM_NONPACKAGED_DOCUMENTATION_DIRECTORY,
	B_SYSTEM_NONPACKAGED_LIB_DIRECTORY,
	B_SYSTEM_NONPACKAGED_HEADERS_DIRECTORY,
	B_SYSTEM_NONPACKAGED_DEVELOP_DIRECTORY,

	/* User directories. These are interpreted in the context
	   of the user making the find_directory call. */
	B_USER_DIRECTORY					= 3000,
	B_USER_CONFIG_DIRECTORY,
	B_USER_ADDONS_DIRECTORY,
	B_USER_BOOT_DIRECTORY,
	B_USER_FONTS_DIRECTORY,
	B_USER_LIB_DIRECTORY,
	B_USER_SETTINGS_DIRECTORY,
	B_USER_DESKBAR_DIRECTORY,
	B_USER_PRINTERS_DIRECTORY,
	B_USER_TRANSLATORS_DIRECTORY,
	B_USER_MEDIA_NODES_DIRECTORY,
	B_USER_SOUNDS_DIRECTORY,
	B_USER_DATA_DIRECTORY,
	B_USER_CACHE_DIRECTORY,
	B_USER_PACKAGES_DIRECTORY,
	B_USER_HEADERS_DIRECTORY,
	B_USER_NONPACKAGED_DIRECTORY,
	B_USER_NONPACKAGED_ADDONS_DIRECTORY,
	B_USER_NONPACKAGED_TRANSLATORS_DIRECTORY,
	B_USER_NONPACKAGED_MEDIA_NODES_DIRECTORY,
	B_USER_NONPACKAGED_BIN_DIRECTORY,
	B_USER_NONPACKAGED_DATA_DIRECTORY,
	B_USER_NONPACKAGED_FONTS_DIRECTORY,
	B_USER_NONPACKAGED_SOUNDS_DIRECTORY,
	B_USER_NONPACKAGED_DOCUMENTATION_DIRECTORY,
	B_USER_NONPACKAGED_LIB_DIRECTORY,
	B_USER_NONPACKAGED_HEADERS_DIRECTORY,
	B_USER_NONPACKAGED_DEVELOP_DIRECTORY,
	B_USER_DEVELOP_DIRECTORY,
	B_USER_DOCUMENTATION_DIRECTORY,
	B_USER_SERVERS_DIRECTORY,
	B_USER_APPS_DIRECTORY,
	B_USER_BIN_DIRECTORY,
	B_USER_PREFERENCES_DIRECTORY,
	B_USER_ETC_DIRECTORY,
	B_USER_LOG_DIRECTORY,
	B_USER_SPOOL_DIRECTORY,
	B_USER_VAR_DIRECTORY,

	/* Global directories. */
	B_APPS_DIRECTORY					= 4000,
	B_PREFERENCES_DIRECTORY,
	B_UTILITIES_DIRECTORY,
	B_PACKAGE_LINKS_DIRECTORY,

	/* Obsolete: Legacy BeOS definition to be phased out */
	B_BEOS_DIRECTORY					= 1000,
	B_BEOS_SYSTEM_DIRECTORY,
	B_BEOS_ADDONS_DIRECTORY,
	B_BEOS_BOOT_DIRECTORY,
	B_BEOS_FONTS_DIRECTORY,
	B_BEOS_LIB_DIRECTORY,
	B_BEOS_SERVERS_DIRECTORY,
	B_BEOS_APPS_DIRECTORY,
	B_BEOS_BIN_DIRECTORY,
	B_BEOS_ETC_DIRECTORY,
	B_BEOS_DOCUMENTATION_DIRECTORY,
	B_BEOS_PREFERENCES_DIRECTORY,
	B_BEOS_TRANSLATORS_DIRECTORY,
	B_BEOS_MEDIA_NODES_DIRECTORY,
	B_BEOS_SOUNDS_DIRECTORY,
} directory_which;


/* find_path[s]() flags */
enum {
	B_FIND_PATH_CREATE_DIRECTORY			= 0x0001,
	B_FIND_PATH_CREATE_PARENT_DIRECTORY		= 0x0002,
	B_FIND_PATH_EXISTING_ONLY				= 0x0004,

	B_FIND_PATHS_SYSTEM_ONLY				= 0x0010,
	B_FIND_PATHS_USER_ONLY					= 0x0020,
};


typedef enum path_base_directory {
	B_FIND_PATH_INSTALLATION_LOCATION_DIRECTORY,
	B_FIND_PATH_ADD_ONS_DIRECTORY,
	B_FIND_PATH_APPS_DIRECTORY,
	B_FIND_PATH_BIN_DIRECTORY,
	B_FIND_PATH_BOOT_DIRECTORY,
	B_FIND_PATH_CACHE_DIRECTORY,
	B_FIND_PATH_DATA_DIRECTORY,
	B_FIND_PATH_DEVELOP_DIRECTORY,
	B_FIND_PATH_DEVELOP_LIB_DIRECTORY,
	B_FIND_PATH_DOCUMENTATION_DIRECTORY,
	B_FIND_PATH_ETC_DIRECTORY,
	B_FIND_PATH_FONTS_DIRECTORY,
	B_FIND_PATH_HEADERS_DIRECTORY,
	B_FIND_PATH_LIB_DIRECTORY,
	B_FIND_PATH_LOG_DIRECTORY,
	B_FIND_PATH_MEDIA_NODES_DIRECTORY,
	B_FIND_PATH_PACKAGES_DIRECTORY,
	B_FIND_PATH_PREFERENCES_DIRECTORY,
	B_FIND_PATH_SERVERS_DIRECTORY,
	B_FIND_PATH_SETTINGS_DIRECTORY,
	B_FIND_PATH_SOUNDS_DIRECTORY,
	B_FIND_PATH_SPOOL_DIRECTORY,
	B_FIND_PATH_TRANSLATORS_DIRECTORY,
	B_FIND_PATH_VAR_DIRECTORY,

	/* find_path() only */
	B_FIND_PATH_IMAGE_PATH			= 1000,
	B_FIND_PATH_PACKAGE_PATH,
} path_base_directory;


#ifdef __cplusplus
extern "C" {
#endif

/* C interface */

status_t find_directory(directory_which which, dev_t volume, bool createIt,
	char* pathString, int32 length);

status_t find_path(const void* codePointer, path_base_directory baseDirectory,
	const char* subPath, char* pathBuffer, size_t bufferSize);

status_t find_path_etc(const void* codePointer, const char* dependency,
	const char* architecture, path_base_directory baseDirectory,
	const char* subPath, uint32 flags, char* pathBuffer, size_t bufferSize);

status_t find_path_for_path(const char* path, path_base_directory baseDirectory,
	const char* subPath, char* pathBuffer, size_t bufferSize);

status_t find_path_for_path_etc(const char* path, const char* dependency,
	const char* architecture, path_base_directory baseDirectory,
	const char* subPath, uint32 flags, char* pathBuffer, size_t bufferSize);

status_t find_paths(path_base_directory baseDirectory, const char* subPath,
	char*** _paths, size_t* _pathCount);

status_t find_paths_etc(const char* architecture,
	path_base_directory baseDirectory, const char* subPath, uint32 flags,
	char*** _paths, size_t* _pathCount);


#ifdef __cplusplus
}

/* C++ interface */

class BVolume;
class BPath;


status_t find_directory(directory_which which, BPath* path,
	bool createIt = false, BVolume* volume = NULL);


#endif	/* __cplusplus */

#endif	/* _FIND_DIRECTORY_H */
