/*
 * Copyright 2018-2024, ttcoder of TTS-LLC
 * All rights reserved. Distributed under the terms of the MIT license.
 */
#ifndef _WindowNitpickerPriv_H
#define _WindowNitpickerPriv_H


// genode/base.a
#ifdef HAS_MICRO_WINDOW_MANAGER
#include <input_session/connection.h>  // Input::Event
#endif


namespace hog {
	//class MouseState;
	class Wm;
}



//#pragma mark -


/*
class hog::MouseState
{
	// Pointing device's latest state retrieved from Genode.Input
	// (Used by: BView.GetMouse() et alia)

public:

		MouseState()
		:	curScreenWhere()
			,curButtons( 0 )
		{
		}
		  
public:  // !

		// current/last-known state, in Haiku API parlance
		BPoint curScreenWhere;
		int32  curButtons;
};
*/


#ifdef HAS_MICRO_WINDOW_MANAGER

class hog::Wm
{
	// A microscopic "window manager", so that our (Be-style) windows can be moved
	// and closed even though they interact only with Nitpicker (but not with the true Genode/MOTIF Wm)
	// and draw their own window decorations.
	
public:
		Wm( BWindow & win );
		
		void HandleEvent(
			const Input::Event & ev,
		//	const hog::MouseState & state
			const BPoint curScreenWhere
		//	const uint32 curButtons
			);

private:

		BWindow & ourWin;
		
		bool isDragging;  // if true, we're moving the window with the below hot-spot
		BPoint trackWithHot;
};

#endif  // ~HAS_MICRO_WINDOW_MANAGER



#endif // _WindowNitpickerPriv_H

