/*
 * Copyright 2024, ttcoder
 * All rights reserved. Distributed under the terms of the MIT license.
 */
#ifndef _GeNitWindow_H
#define _GeNitWindow_H


// genode/base.a
namespace Gui {
	class  Connection;
}
namespace Input {
	class  Session_client;
}

// haiku.lib.so
class BWindow;
namespace hog {
	class NitWindowBase;
	
	class InputBridger;
	///ToDo: replace these with static/factory type functions, using a "Base" class shielding mechanism (similar to NitWinBase vs. NitWinPrivate)
	extern InputBridger * create_in_bri( BWindow & win );
	extern void destroy_in_bri( InputBridger * ptr );
};



class hog::NitWindowBase
{
	// Hide the implementation details behind this "base"/"interface"
	// (to avoid header clashes between Ge and Hai headers)
	
public:

		// Xtors
		
		virtual ~NitWindowBase();
		
	static
		hog::NitWindowBase * Instantiate( BBitmap * offscreen_bitmap );
		
		// Canvas "firewall/shim":
		
		void Canvas_SetOriginAndClipping( BPoint, BRect );
		void Canvas_FillRect( BRect, rgb_color );
		void Canvas_Update();
		
	virtual CanvasGenode & Canvas() = 0; //+ "PaintingSurface" ?
	virtual Input::Session_client & Input() = 0;
	
	virtual void Create_Bare_Window() = 0;
	virtual void Destroy_Bare_Window() = 0;
	virtual void Set_Title( const char * title ) = 0;
	virtual void To_Front() = 0;
	virtual void To_Back() = 0;
	virtual void Background() = 0;
	virtual void SetClientGeometry( BRect inner_rect ) = 0;//Gui::Rect inner_rect );
#ifdef HAS_MICRO_WINDOW_MANAGER
	virtual Gui::Connection & ConnectionAndGeom() = 0;//nah!: ///+ "DecoratedGeom" ?
	virtual void Set_ClientSide_Decorations(
			BRect inner_frame,
			BRect tab_frame,
			float border_thickness
			) = 0;
#endif
};


#endif // _GeNitWindow_H

