/*
 * Copyright 2012-2017 Haiku, Inc. All rights reserved.
 * Distributed under the terms of the MIT License.
 */


#include <ControlLook.h>


namespace BPrivate {


BControlLook::BControlLook()
	:
	fCachedWorkspace(-1)
{
}


BControlLook::~BControlLook()
{
}


float
BControlLook::ComposeSpacing(float spacing)
{
	switch ((int)spacing) {
		case B_USE_DEFAULT_SPACING:
		case B_USE_ITEM_SPACING:
			return be_control_look->DefaultItemSpacing();
		case B_USE_HALF_ITEM_SPACING:
			return ceilf(be_control_look->DefaultItemSpacing() * 0.5f);
		case B_USE_WINDOW_SPACING:
			return be_control_look->DefaultItemSpacing();
		case B_USE_SMALL_SPACING:
			return ceilf(be_control_look->DefaultItemSpacing() * 0.7f);
		case B_USE_BIG_SPACING:
			return ceilf(be_control_look->DefaultItemSpacing() * 1.3f);
	}

	return spacing;
}


void
BControlLook::DrawLabel(BView* view, const char* label, const BBitmap* icon,
	BRect rect, const BRect& updateRect, const rgb_color& base, uint32 flags,
	const rgb_color* textColor)
{
	DrawLabel(view, label, icon, rect, updateRect, base, flags,
		DefaultLabelAlignment(), textColor);
}


void
BControlLook::GetInsets(frame_type frameType, background_type backgroundType,
	uint32 flags, float& _left, float& _top, float& _right, float& _bottom)
{
	GetFrameInsets(frameType, flags, _left, _top, _right, _bottom);

	float left, top, right, bottom;
	GetBackgroundInsets(backgroundType, flags, left, top, right, bottom);

	_left += left;
	_top += top;
	_right += right;
	_bottom += bottom;
}


void
BControlLook::SetBackgroundInfo(const BMessage& backgroundInfo)
{
	fBackgroundInfo = backgroundInfo;
	fCachedWorkspace = -1;
}


void BControlLook::_ReservedControlLook1() {}
void BControlLook::_ReservedControlLook2() {}
void BControlLook::_ReservedControlLook3() {}
void BControlLook::_ReservedControlLook4() {}
void BControlLook::_ReservedControlLook5() {}
void BControlLook::_ReservedControlLook6() {}
void BControlLook::_ReservedControlLook7() {}
void BControlLook::_ReservedControlLook8() {}
void BControlLook::_ReservedControlLook9() {}
void BControlLook::_ReservedControlLook10() {}


// NOTE: May come from a add-on in the future. Initialized in
// InterfaceDefs.cpp
BControlLook* be_control_look = NULL;


} // namespace BPrivate
