/*
 * Copyright 2024, ttcoder
 * All rights reserved. Distributed under the terms of the MIT license.
 */


// genode/base.lib.a
#include <nitpicker_gfx/tff_font.h>

// this
#include "_GeFontStash.h"



/************
* FontStash has to be in global be_apps, so that class BFont may remain a fly-weight
* object that just refers to (rather than copy) the actual font data
*/

static Text_painter::Font * defFont = NULL;

#if 1
// Statically linked data:
//extern char _binary_droidsansb10_tff_start[];
extern char _binary_default_tff_start[];

///ToDo: make these *members* ; then make stash inherit BLock, and protect everything with BAutoLock( stash )
static Tff_font::Static_glyph_buffer<4096> _glyph_buffer { };
static Tff_font _font_trivial { _binary_default_tff_start, _glyph_buffer };

#else

#include <base/attached_rom_dataspace.h>
#include <base/heap.h>
#include <gems/ttf_font.h>
///ToDo: optimization: use the font glyph (gems/cached_font.h ?), drawing TTF fonts is slower than TFF
#endif


FontStash::FontStash()
{
#if 1
	defFont = &_font_trivial;

#else

	Genode::Env &
		HogEnv();
	static Genode::Attached_rom_dataspace _vera_ttf_ds { HogEnv(), "Vera.ttf" };
	static Genode::Heap _heap { HogEnv().ram(), HogEnv().rm() };
	static Ttf_font _font_TrueType {
		_heap,
		_vera_ttf_ds.local_addr<void>(),
		13
		};
	
	defFont = &_font_TrueType;
#endif
}

/*
FontStash::FontStash( const FontStash & peer )
{
	//+ init from <peer>..
}
*/


FontStash::opaque_painter  FontStash::Font( int font_id ) const
//const struct FontStash::opaque_painter &
//const Text_painter::Font &
//	FontStash::Font( int font_id ) const
{
//	return *defFont;
	return opaque_painter { defFont };
}
/*
float FontStash::FontHeight( int font_id ) const
{
	///+++ use this method in Canvas et al?
	
	return defFont->height();
}
*/


