## Contents description:

The **haiku.lib.so** deliverable is an all-in-one library, by contrast to upstream (original Haiku) which spreads out the ABI over libbe.so, libmedia.so etc.
However, our *directory* organisation still reflects the original split into multiple libraries:

- headers/ : does not contain quite the same set of headers as upstream, e.g. most public API headers like Window.h, Application.h etc, are consolidated together with their .cpp counterpart inside kits/ instead of being separated in headers/.
- kits/ contains the code formerly know as **libbe.so** / libmedia.so / etc, i.e. code needed by apps that (used to) link against libbe.so (typically "desktop" apps, whereas command-line tools tend to only link against libroot.so).
- sys-icon/ contains code used by kits/interface-private.
- sys-libs/ contains the libroot code, which is a linking requirement for both CLI apps and 'desktop' apps.
- kernel/ (todo: currently still named "system/") contains the pseudo "kernel".

If you're not familiar with the role of the original libraries, think of **libbe.so** as the one providing full support to desktop (GUI) applications, since it provides classes like BWindow, BView, BButton and so on (the so-called Interface Kit), classes like BFile, BDirectory etc (the so-called Storage Kit).
Think of **libmedia.so** as the one providing support for audio and video playback, with classes like BMediaFile and BMediaTrack.
As to **libroot.so**, think of it as a thin extra layer on top of FreeBSD's libc.so library.
It provides C-style APIs that support the C++ classes in libbe.So
(BNode.ReadAttr() relies on <code>kern_read_attr()</code>,
BStatable relies on <code>kern_read_stat()</code>, and so on).

