/*
 * Copyright 2023-2024, ttcoder
 * All rights reserved. Distributed under the terms of the MIT license.
 */
#ifndef _geno_init_pilot_H
#define _geno_init_pilot_H


// genode base.a
#include <os/reporter.h>  // member

// haiku.lib.so
#include "_Ge_Pilot.h"  // Ancestor


namespace hog {
	class InitPilot;
};


class hog::InitPilot : public hog::Pilot
{
	// WHAT
	// Drive/manage an "init" Genode component:
	// - handle init launching of several different component/apps
	// - listen to init reporting back to us about apps quitting or crashing
	//
	// A.K.A.
	// - InitManager
	// - TalkToDynInit
	// - DynRunRosterState
	
public:
		InitPilot();
		
private:  // Code
		void genAndSendConf() override;
		
		BString genHeader();
		BString genOneChildConf( const BStringList & arg_list, const BString & xml_conf, int ram_quota_megs );

private:  // Data
		// Tx to Genode-Init ("Dynit")
		Genode::Reporter dynTx;
};


#endif // _geno_init_pilot_H

