/*
 * Copyright 2023-2024, ttcoder
 * All rights reserved. Distributed under the terms of the MIT license.
 */
#ifndef _geno_deploy_pilot_H
#define _geno_deploy_pilot_H


// haiku.lib.so
#include "_Ge_Pilot.h"  // Ancestor


namespace hog {
	class DeployPilot;
};


class hog::DeployPilot : public hog::Pilot
{
	// WHAT
	// This manages a "depot_deploy" component (which in turn
	// controls its own "init"/"dynamic" component).
	// The XML needed to 'pilot' it is similar to (but not the same) as the
	// 'init' syntax, so the XML we generate in DeployPilot is significantly
	// different from the one generated in InitPilot.
	
public:
		DeployPilot();
		
private:  // Code
		void genAndSendConf() override;
		
		BString genOneChildConf( const BStringList & arg_list, const BString & xml_conf );

private:  // Data
		// Tx to "depot_deploy"
		Genode::Reporter depotDeployTx;
};


#endif // _geno_deploy_pilot_H

