
if ! $(routing_server_for_depot)
{
	EXIT "*** geDepotDaemon.inc: no VFS: you forgot to declare 'local routing_server_for_depot = vfs_ram' or some such" ;
}


if ! $(RunTarget_for_DepotDaemonInc)
{
	EXIT "*** geDepotDaemon.inc: no RUN jam-target: you forgot to declare 'local RunTarget_for_DepotDaemonInc = myscenario.run' or some such" ;
}
local target_for_depotdaemon = $(RunTarget_for_DepotDaemonInc) ;  # e.g. "hog-deskbar.run"


if ! $(small_ram_quota_for_depot)
{
	EXIT "*** geDepotDaemon.inc: no Ram Quota: you forgot to declare 'local small_ram_quota_for_depot = true' or 'false'..." ;
}
local ram_quota_for_deployer	= "16G" ;
local ram_quota_for_cachedroms	= "390M" ;  # Falkon alone loads more than 250 MB worth of ROMs, Morph loads 310 MB
#///ToDo: not good enough, increase it some more : if we load both Falkon and another app cached_fs_rom gets "stuck" on a resource request, until a reboot (is there no way to dial it up and down from the parent init's RAM ? Or just cancel the launch on OOM, to avoid a reboot ?)
if $(small_ram_quota_for_depot) = "true"
{
	# probably a Qemu run, so keep things low-key
	ram_quota_for_deployer		= "150M" ;
	ram_quota_for_cachedroms	= "10M" ;
}



# Depot Download
#
# --> this will query (and make a local cache of) https://depot.genode.org, and if needed, download/verify/extract tar.xz archives into "/depot/genodelabs/"
#
AddRawComponent		$(target_for_depotdaemon) : chroot : chroot ;
AddComponentAsStart	$(target_for_depotdaemon) : 70M : init :
		"name=\"depot_download\" caps=\"2000\"" : "
	\	<binary name=\"init\"/>
	\	<route>
	\		<service name=\"File_system\"> <child name=\"$(routing_server_for_depot)\"/> </service>
	\		<service name=\"ROM\" label=\"manager -> installation\"> <child name=\"dynit_report_rom\" /> </service>
#///
	\		<service name=\"LOG\">  <child name=\"udp_log\"/> <child name=\"term_app_log\"/> <parent/>  </service>
				# "Nic" etc get routed up:
	\		<any-service> <parent/> <any-child/> </any-service>
	\	</route>
	\	<config>
	\		<parent-provides>
	\			<service name=\"ROM\"/>
	\			<service name=\"PD\"/>
	\			<service name=\"RM\"/>
	\			<service name=\"CPU\"/>
	\			<service name=\"LOG\"/>
	\			<service name=\"Timer\"/>
	\			<service name=\"Report\"/>
	\			<service name=\"File_system\"/>
	\			<service name=\"Nic\"/>
	\		</parent-provides>
	\		<default-route>
	\			<any-service> <parent/> <any-child/> </any-service>
	\		</default-route>
	\		<default caps=\"100\"/>
			"
		# -- split string to dodge Jam crash --
			"
	\		
	\		<start name=\"report_rom\">
	\			<resource name=\"RAM\" quantum=\"2M\"/>
	\			<provides> <service name=\"Report\"/> <service name=\"ROM\"/> </provides>
	\			<config verbose=\"no\">
	\				<policy label=\"dynamic -> config\"
	\					report=\"manager -> init_config\"/>
	\				<policy label=\"manager -> dependencies\"
	\					report=\"dynamic -> depot_query -> dependencies\"/>
	\				<policy label=\"manager -> index\"
	\					report=\"dynamic -> depot_query -> index\"/>
	\				<policy label=\"manager -> image\"
	\					report=\"dynamic -> depot_query -> image\"/>
	\				<policy label=\"manager -> image_index\"
	\					report=\"dynamic -> depot_query -> image_index\"/>
	\				<policy label=\"manager -> user\"
	\					report=\"dynamic -> depot_query -> user\"/>
	\				<policy label=\"manager -> init_state\"
	\					report=\"dynamic -> state\"/>
	\				<policy label=\"manager -> verified\"
	\					report=\"dynamic -> verify -> result\"/>
	\				<policy label=\"manager -> fetchurl_progress\"
	\					report=\"dynamic -> fetchurl -> progress\"/>
	\			</config>
	\		</start>
	\		<start name=\"tcpip\" caps=\"400\">
	\			<binary name=\"vfs\"/>
	\			<resource name=\"RAM\" quantum=\"32M\" />
	\			<provides> <service name=\"File_system\"/> </provides>
	\			<config>
	\				<vfs>
	\					<dir name=\"socket\">
	\						<lwip dhcp=\"yes\"/>
	\					</dir>
	\				</vfs>
	\				<default-policy root=\"/\" writeable=\"yes\"/>
	\			</config>
	\			<route> <any-service> <parent/> </any-service> </route>
	\		</start>
	\		<start name=\"depot_ro\">
	\			<binary name=\"chroot\"/>
	\			<resource name=\"RAM\" quantum=\"2M\" />
	\			<provides> <service name=\"File_system\"/> </provides>
	\			<config>
	\				<default-policy path=\"/\" writeable=\"no\"/>
	\			</config>
	\			<route>
	\				<service name=\"File_system\"> <parent label=\"depot\"/> </service>
	\				<any-service> <parent/> </any-service>
	\			</route>
	\		</start>
			"
		# -- split string to dodge Jam crash --
			"
	\		<start name=\"public_ro\">
	\			<binary name=\"chroot\"/>
	\			<resource name=\"RAM\" quantum=\"2M\" />
	\			<provides> <service name=\"File_system\"/> </provides>
	\			<config>
	\				<default-policy path=\"/\" writeable=\"no\"/>
	\			</config>
	\			<route>
	\				<service name=\"File_system\"> <parent label=\"public\"/> </service>
	\				<any-service> <parent/> </any-service>
	\			</route>
	\		</start>
	\
	\		<start name=\"manager\">
	\			<binary name=\"depot_download_manager\"/>
	\			<resource name=\"RAM\" quantum=\"2M\"/>
	\			<config/>
	\			<route>
					<service name=\"Report\" label=\"state\"> <child name=\"report_rom\" label=\"state\"/> </service>
#					<service name=\"Report\" label=\"state\"> <parent label=\"state\"/> </service>
	\				<service name=\"Report\"> <child name=\"report_rom\"/> </service>
	\				<service name=\"ROM\" label=\"dependencies\">      <child name=\"report_rom\"/> </service>
	\				<service name=\"ROM\" label=\"installation\">	<parent /> </service>
	\				<service name=\"ROM\" label=\"index\">             <child name=\"report_rom\"/> </service>
	\				<service name=\"ROM\" label=\"image\">             <child name=\"report_rom\"/> </service>
	\				<service name=\"ROM\" label=\"image_index\">       <child name=\"report_rom\"/> </service>
	\				<service name=\"ROM\" label=\"user\">              <child name=\"report_rom\"/> </service>
	\				<service name=\"ROM\" label=\"init_state\">        <child name=\"report_rom\"/> </service>
	\				<service name=\"ROM\" label=\"verified\">          <child name=\"report_rom\"/> </service>
	\				<service name=\"ROM\" label=\"fetchurl_progress\"> <child name=\"report_rom\"/> </service>
	\				<any-service> <parent/> <any-child/> </any-service>
	\			</route>
	\		</start>
			"
		# -- split string to dodge Jam crash --
			"
	\		<start name=\"dynamic\" caps=\"1000\">
	\			<resource name=\"RAM\" quantum=\"24M\"/>
	\			<binary name=\"init\"/>
	\			<route>
	\				<service name=\"ROM\" label=\"config\"> <child name=\"report_rom\"/> </service>
	\				<service name=\"Report\"> <child name=\"report_rom\"/> </service>
	\				<service name=\"File_system\" label=\"depot\">     <child name=\"depot_ro\"/>  </service>
	\				<service name=\"File_system\" label=\"depot_rw\">  <parent label=\"depot\"/>   </service>
	\				<service name=\"File_system\" label=\"public\">    <child name=\"public_ro\"/> </service>
	\				<service name=\"File_system\" label=\"public_rw\"> <parent label=\"public\"/>  </service>
	\				<service name=\"File_system\" label=\"tcpip\">     <child name=\"tcpip\"/>     </service>
	\				<any-service> <parent/> <any-child/> </any-service>
	\			</route>
	\		</start>
	\	</config>
		"
		;


# Deploy/Run-depot-apps
#
# --> This launches executables (into a dynamic init) from packages previously installed by depot_download (down there)
#	NOTE: unlike dynit, our dynamic init will be fed the "start PKG=... NAME=" syntax instead of "start NAME=.. "
#
AddComponentAsStart	$(target_for_depotdaemon) : $(ram_quota_for_deployer) : init :
			"name=\"run_depot\" caps=\"16000\""  :  "
	\	<binary name=\"init\"/>
	\	<route>
	\			<!-- Disambiguation is needed in some cases: -->
	\		<service name=\"File_system\" label=\"ram_fs\">		<child name=\"ram_fs\"/> </service>
	\		<service name=\"File_system\">	<child name=\"$(routing_server_for_depot)\"/> </service>
	\		<service name=\"Gui\">			<child name=\"wm\"/> <child name=\"nitpicker\"/>  </service>
	\		<service name=\"Audio_out\">	<child name=\"mixer\"/> </service>
#///FIXME: temporarily using black_hole (instead of mixer) to unblock new Falkon, but let's quickly restore mixer i.e. migrate from "audio out" to "Play" interface
###	\		<service name=\"Play\">			<child name=\"mixer\"/> </service>
	\		<service name=\"Play\">			<child name=\"black_hole\"/> </service>
										#///later-2: audio-in support for Falkon etc (video-conferencing?):
	\		<service name=\"Audio_in\">		<child name=\"black_hole\"/> </service>
	\		<service name=\"Record\">		<child name=\"black_hole\"/> </service>
	\		<service name=\"Event\"> <child name=\"drivers_init\" label=\"vnc\"/> <child name=\"event_filter\" label=\"vnc\"/> </service>
	\		<service name=\"Report\" label=\"dynamic -> state\"> <child name=\"dynit_report_rom\"/> </service>
	\		<service name=\"Report\" label=\"depot_deploy -> state\"> <child name=\"dynit_report_rom\"/> </service>
	\		<service name=\"Report\" label_last=\"shape\"> <child name=\"wm\"/> </service>
#	\		<service name=\"Report\" label_last=\"clipboard\"> <child name=\"wm\"/> </service>
#	\		<service name=\"ROM\"    label_last=\"clipboard\"> <child name=\"wm\"/> </service>
		#///
	\		<service name=\"LOG\">  <child name=\"udp_log\"/> <child name=\"term_app_log\"/> <parent/>  </service>
	\		<service name=\"ROM\" label=\"depotdeploy.config\"> <child name=\"dynit_report_rom\" /> </service>
	\		<any-service> <parent/> <any-child/> </any-service>
	\	</route>
	\	<config>
	\		<parent-provides>
	\			<service name=\"ROM\"/>
	\			<service name=\"PD\"/>
	\			<service name=\"RM\"/>
	\			<service name=\"CPU\"/>
	\			<service name=\"LOG\"/>
	\			<service name=\"Timer\"/>
	\			<service name=\"Report\"/>
	\			<service name=\"Gui\"/>
	\			<service name=\"Rtc\"/>
	\			<service name=\"Nic\"/>
	\			<service name=\"Audio_out\"/>
	\			<service name=\"Audio_in\"/>
	\			<service name=\"Play\"/>
	\			<service name=\"Record\"/>
	\			<service name=\"File_system\"/>
	\			<service name=\"Capture\"/>
	\			<service name=\"Event\"/>
	\		</parent-provides>
	\		<default-route>
	\			<any-service> <parent/> </any-service>
	\		</default-route>
	\		<default caps=\"100\"/>
			"
		# -- split string to dodge Jam crash --
			"
	\		<start name=\"report_rom\">
	\			<resource name=\"RAM\" quantum=\"1M\"/>
	\			<provides> <service name=\"Report\"/> <service name=\"ROM\"/> </provides>
	\			<config verbose=\"no\">
	\					<!-- depot_deploy sends a 'query' to depot_query, which responds with a runtime 'blueprint' which may be applied to 'dynamic' -->
	\				<policy label=\"depot_query -> query\"		report=\"depot_deploy -> query\"/>
	\				<policy label=\"depot_deploy -> blueprint\" report=\"depot_query -> blueprint\"/>
	\					<!-- depot_deploy then configures 'dynamic'... As to itself, it gets configured by registrar -->
	\				<policy label=\"dynamic -> config\"			report=\"depot_deploy -> init.config\"/>
	\					<!-- That should suffice, seems there's no need here for policy re installation/image/image_index/user, unlike in the 'depot_download' section -->
	\			</config>
	\		</start>
			"
		# -- split string to dodge Jam crash --
			"
	\		<start name=\"depot_query\">
	\			<resource name=\"RAM\" quantum=\"2M\"/>
	\			<config query=\"rom\">
	\					<!-- Our config is (partially) driven through a report_rom -->
	\					<!-- (however, for testing purposes one can disable 'query=rom' and setup an e.g. <index user=.. version=..> node here) -->
	\				<vfs> <dir name=\"depot\"> <fs label=\"depot\"/> </dir> </vfs>
	\			</config>
	\			<route>
	\				<service name=\"ROM\" label=\"query\">	<child name=\"report_rom\"/> </service>
	\				<service name=\"Report\">				<child name=\"report_rom\"/> </service>
	\				<any-service> <parent/> <any-child/> </any-service>
	\			</route>
	\		</start>
			"
		# -- split string to dodge Jam crash --
			"
	\		<start name=\"depot_deploy\">
	\			<resource name=\"RAM\" quantum=\"1M\"/>
	\			<route>
	\					<!-- depot_deploy is configured/piloted by registrar -->
	\				<service name=\"ROM\" label=\"config\"> <parent label=\"depotdeploy.config\"/> </service>
	\					<!-- We report a query, get a blueprint response, and then configure the init -->
	\				<service name=\"Report\" label=\"query\"> <child name=\"report_rom\"/> </service>
	\				<service name=\"ROM\"    label=\"blueprint\"> <child name=\"report_rom\"/> </service>
	\				<service name=\"Report\" label=\"init.config\"> <child name=\"report_rom\"/> </service>
	\				<any-service> <parent/> <any-child/> </any-service>
	\			</route>
		#		<config arch=\"x86_64\">
		#			<common_routes.....>
		#			<start name=\"nano3d\" pkg=\"genodelabs/pkg/nano3d/2023-04-25\" />
		#		</config>
	\		</start>
			"
		# -- split string to dodge Jam crash --
			"
			# T+
			#	launch cached_fs_rom *one-from-last* so that we can dial its RAM up/down and it will only affect dynamic.
			#
			# query: _find_rom_in_pkg() and _gen_rom_path_nodes() will find the full path to the 'nano3d' etc ROMs,
			# and will send requests to cached_fs_rom for depot-relative paths like "/genodelabs/bin/x86_64/nano3d/2023-04-25/nano3d"
			# to make a ROM out of it:
			#
	\		<start name=\"cached_fs_rom\">
	\			<resource name=\"RAM\" quantum=\"$(ram_quota_for_cachedroms)\" />
	\			<provides> <service name=\"ROM\"/> </provides>
	\			<route>
	\					<!-- We need to specify the label by hand here for some reason: -->
	\				<service name=\"File_system\"> <parent label=\"cached_fs_rom\"/> </service>
	\				<any-service> <parent/> <any-child/> </any-service>
	\			</route>
	\		</start>
	\		
#///ToDo-2: rename... We have two "dynamic" (init) components
			# T++
			#	launch dynamic *last* so that it eats up the remainder of this init's RAM
			#	(and lots of caps, Falkon reserves 9700 caps)
	\		<start name=\"dynamic\" caps=\"15000\">
	\			<resource name=\"RAM\" quantum=\"$(ram_quota_for_deployer)\"/>
	\			<binary name=\"init\"/>
	\			<route>
	\				<service name=\"ROM\" label=\"config\"> <child name=\"report_rom\"/> </service>
	\				<service name=\"ROM\" label_last=\"ld.lib.so\"> <parent/> </service>
	\				<service name=\"ROM\" label_last=\"init\">      <parent/> </service>
	\				<service name=\"ROM\" label_last=\"shim\">      <parent/> </service>
	\				<service name=\"ROM\">   <child name=\"cached_fs_rom\"/> </service>
	\				<service name=\"File_system\" label_prefix=\"ram_fs\">	<parent label=\"ram_fs\"/> </service>
	\				<any-service> <parent/> <any-child/> </any-service>
	\			</route>
	\		</start>
	\	</config>
		"
		;



AddRawComponent		$(target_for_depotdaemon) : depot_query : depot_query ;
AddRawComponent		$(target_for_depotdaemon) : depot_deploy : depot_deploy ;
AddRawComponent		$(target_for_depotdaemon) : depot_download_manager : depot_download_manager ;
AddRawComponent		$(target_for_depotdaemon) : curl.lib.so : curl.lib.so ;
AddRawComponent		$(target_for_depotdaemon) : libssh.lib.so : libssh.lib.so ;
AddRawComponent		$(target_for_depotdaemon) : libssl.lib.so : libssl.lib.so ;
AddRawComponent		$(target_for_depotdaemon) : libcrypto.lib.so : libcrypto.lib.so ;
AddRawComponent		$(target_for_depotdaemon) : fetchurl : fetchurl ;
AddRawComponent		$(target_for_depotdaemon) : libarchive.lib.so : libarchive.lib.so ;
AddRawComponent		$(target_for_depotdaemon) : liblzma.lib.so : liblzma.lib.so ;
AddRawComponent		$(target_for_depotdaemon) : extract : extract ;
#///later-2: check integrity: add app/verify, then enable -> verify="yes" to check the pub-key of GenodeLabs downloaded archives


