#
# Deskbar unit test -- Invoke:
#		jam -q hog-deskbar.emu8
# to run a Deskbar test scenario.
#
# [x] Disable the Deskbar_FULL_TEST variable for simplified quick testing.
# [x] Enable  the Deskbar_FULL_TEST variable for testing the "Shutdown" feature,
#     i.e. to access Deskbar's menu item directing registrar to issue a "reset" report to ACPICA.
#

##Echo "[JAM_TARGETS: " $(JAM_TARGETS) "]" "[LayerLevel: " $(LayerLevel) "]" ;


# Compilation
# --> HoG improvement : enable "suspend to RAM"
SubDirC++Flags -DAPM_SUPPORT ;
UsePrivateSystemHeaders ;  # for syscalls.h


#///ToDo: rename Deskbar_FULL_TEST to S3_SLEEP_TEST
if $(Deskbar_FULL_TEST)
{
	# we'll manage a couple drivers ourselves, to support suspend-to-RAM/resume
	AddInteractiveComponents  hog-deskbar.run : NO_fb_DRIVER NO_ps2_DRIVER ;
}
else
{
	AddInteractiveComponents  hog-deskbar.run ;
}

# Deskbar runs at "emu8" level (with a whole haiku.lib.so, which thus needs media libs)
AddAudioComponents hog-deskbar.run ;


AddComponentService	hog-deskbar.run : 1M : pc_rtc : Rtc ;
AddComponentClient	hog-deskbar.run : 5M : acpica :
	"
\	<config ld_verbose=\"yes\"  sleep=\"yes\" reset=\"no\" poweroff=\"yes\"
		report=\"yes\" acpi_ready=\"no\" act_as_acpi_drv=\"no\" />
\	<route>
\			<!-- Note re. this setting: if not done/correctly, the resulting failure will be silent, i.e. Acpica will not log/warn about its failure to listen to ROM changes -->
\		<service name=\"ROM\" label=\"system\"> <child name=\"platform_report_rom\"/> </service>
\ <!-- ///ToDo: should route to drivers_reports (not report_rom), to be clean, and to support suspend (see: acpi_suspend.run) -->
\		<service name=\"Report\"> <child name=\"report_rom\"/> </service>
\		<any-service> <parent/> <any-child/> </any-service>
\	</route>
	"
	;

#AddComponentService hog-deskbar.run : 4M : dynamic_rom : ROM :
#	"		<config verbose=\"yes\">
#	\			<rom name=\"system\">
#	\				<inline description=\"set system state to 'normal'\">
#	\					<system state=\"normal\"/>
#	\				</inline>
#	\				<sleep milliseconds=\"4000\" />
#	\				<inline description=\"set system state to 'reset'\">
#	\					<system state=\"reset\"/>
#	\				</inline>
#	\				<sleep milliseconds=\"500\" />
#	\			</rom>
#	\		</config>
#	"
#	;



# -- Set this variable to "true" to enable and test Deskbar's Shutdown menu (reset/power-off feature): --

# local Deskbar_FULL_TEST = "true" ;

if $(Deskbar_FULL_TEST)
{
	# test-suspend requires "managing_system=yes" so as to have access to PD suspend ops:
	AddComponentAsStart  hog-deskbar.run : 4M : test-suspend :
			"name=\"test-suspend\" managing_system=\"yes\" caps=\"120\"" :
		"	<config ld_verbose=\"no\">
		\	</config>
		\	<route>
		\		<service name=\"ROM\" label=\"system\"> <child name=\"platform_report_rom\"/> </service>
	#	\		<service name=\"ROM\" label=\"sleep_states\"> <child name=\"drivers_reports\"/> </service>
		\		<service name=\"ROM\" label=\"sleep_states\"> <child name=\"report_rom\"/> </service>
		\		<any-service> <parent/> <any-child/> </any-service>
		\	</route>
			"
			;
	AddComponentAsStart  hog-deskbar.run : 128M : init :
			" name=\"drivers_init\" caps=\"1300\" priority=\"-2\" " :
		"		<binary name=\"init\"/>
		\		<route>
		\			<service name=\"ROM\" label=\"config\">
		\				<child name=\"dynamic_rom\"/>
		\			</service>
		\			<service name=\"ROM\" label=\"system\"> <child name=\"platform_report_rom\" label=\"ps2\"/> </service>  <!-- was: ps2_drv -->
		\			<service name=\"Event\"> <child name=\"event_filter\" label=\"ps2\"/> </service>
		\			<service name=\"Platform\" label=\"ps2\"> <child name=\"platform_drv\" label=\"ps2\"/> </service>  <!-- was: ps2_drv -->
		\			<any-service> <parent/> <any-child/> </any-service>
		\		</route>
		\		<default-route>
		\			<any-service> <parent/> <any-child/> </any-service>
		\		</default-route>
			"
			;
	
	AddComponentService hog-deskbar.run : 4M : dynamic_rom : ROM :
		"		<config verbose=\"yes\">
		\			<rom name=\"config\">
#///later-2: suspend-to-ram: once drivers support suspend'ing, restore testing -- un-comment-out the below two blocks:
#		\				<inline description=\"iteration 0 : no drivers\">
#	\		<config/>
#		\				</inline>
#		\				<sleep milliseconds=\"1000\" />
		\				<inline description=\"iteration 1 : vesa+ps/2 drivers\">
	\		<config prio_levels=\"1\">
	\		<parent-provides>
	\			<service name=\"PD\"/>
	\			<service name=\"CPU\"/>
	\			<service name=\"LOG\"/>
	\			<service name=\"ROM\"/>
	\			<service name=\"Rtc\"/>
	\			<service name=\"Platform\"/>
	\			<service name=\"Report\"/>
	\			<service name=\"Timer\"/>
	\			<service name=\"Capture\"/>
	\			<service name=\"IO_MEM\"/>
	\			<service name=\"IO_PORT\"/>
	\			<service name=\"Event\"/>
	\		</parent-provides>
	\			<start name=\"vesa_fb\" caps=\"1000\">
	\				<resource name=\"RAM\" quantum=\"60M\"/>
	\				<config ld_verbose=\"yes\" width=\"1024\" height=\"768\">
	\					<report connectors=\"yes\"/>
	\				</config>
	\				<route>
						# for PD etc
	\					<any-service> <parent/> <any-child/> </any-service>
	\				</route>
	\			</start>
	\			<start name=\"ps2\" caps=\"100\">
	\				<resource name=\"RAM\" quantum=\"3M\"/>
	\				<config system=\"yes\"
	\					verbose_keyboard=\"no\"
	\					verbose_mouse=\"no\"
	\					verbose_scancodes=\"no\"
	\					/>
	\				<route>
	\					<service name=\"Event\"> <parent label=\"ps2\"/> </service>
						<service name=\"ROM\" label=\"system\"> <parent label=\"system\"/> </service>
	\					<service name=\"Platform\"> <parent label=\"ps2\"/> </service>
	\					<any-service> <parent/> <any-child/> </any-service>
	\				</route>
	\			</start>
	\		</config>
		\				</inline>
		
#		\				<sleep milliseconds=\"25000\" />
#		\				<inline description=\"iteration : last\">
#		\					<config/>
#		\				</inline>
#		\				<sleep milliseconds=\"5000\" />
\				<sleep milliseconds=\"50000\" />
		\			</rom>
		\		</config>
		"
		;
	AddBootModule  hog-deskbar.run : vesa_fb ;
	AddBootModule  hog-deskbar.run : ps2 ;
}


if $(Deskbar_FULL_TEST) || $(BUILD_DISTRO)
{
	AddRawComponent  hog-deskbar.run : top		: top ;
	AddRawComponent  hog-deskbar.run : nano3d	: nano3d ;
	AddRawComponent  hog-deskbar.run : GeDepot	: GeDepot ;
	AddRawComponent  hog-deskbar.run : Pulse	: Pulse ;
	
	AddRawComponent      hog-deskbar.run : vfs_pipe.lib.so : vfs_pipe.lib.so ;
	AddComponentService
		hog-deskbar.run : 4M : vfs : File_system : "
		\		<config ld_verbose=\"yes\">
		\			<vfs>
		\				<dir name=\"dev\">
		\					<log/>
		\				</dir>
		\				<dir name=\"export\">
		\					<dir name=\"bro2app\">
		\						<dir name=\"1\"> <pipe> <fifo name=\"pipe\"/> </pipe> </dir>
		\						<dir name=\"2\"> <pipe> <fifo name=\"pipe\"/> </pipe> </dir>
		\						<dir name=\"3\"> <pipe> <fifo name=\"pipe\"/> </pipe> </dir>
		\						<dir name=\"4\"> <pipe> <fifo name=\"pipe\"/> </pipe> </dir>
		\						<dir name=\"5\"> <pipe> <fifo name=\"pipe\"/> </pipe> </dir>
		\						<dir name=\"6\"> <pipe> <fifo name=\"pipe\"/> </pipe> </dir>
		\					</dir>
		\				</dir>
		\			</vfs>
		\			<default-policy root=\"/export\" writeable=\"yes\"/>
		\		</config>
			"
		;
	AddComponentService
		hog-deskbar.run : 4M : broker_server : Hai_Broker : "
		\		<config>
		\				<!-- /dev/rtc was (briefly) needed, between Genode 23.02 release and its hotfix, might as well leave it now -->
		\			<libc  rtc=\"/dev/rtc\" stdin=\"/dev/null\" stdout=\"/dev/log\" stderr=\"/dev/log\"/>
		\			<vfs>
		\				<dir name=\"dev\">
		\					<log/>
		\					<null/>
		\					<rtc/>
		\						<!-- VFS server's named pipes: /dev/bro2app/1 and so on -->
		\					<fs label=\"downstream\"/>
		\				</dir>
		\			</vfs>
		\		</config>
		\	<route>
		\		<service name=\"File_system\" label=\"downstream\"> <child name=\"vfs\"/> </service>
		\		<any-service> <parent/> <any-child/> </any-service>
		\	</route>
			"
		;
	
	Config_Vfs on hog-deskbar.run +=
		"
		\				<dir name=\"dev\">
		\					<fs label=\"downstream\"/>  <!-- for Broker / bro2app -->
		\				</dir>
		\
		\				<!-- Deskbar's main menu requires /system/data/deskbar/menu_entries, otherwise TBarWindow::MenusBeginning() fails to call SetNavDir() and we get no menu -->
		\				<dir name=\"system\">
		\					<dir name=\"data\">
		\						<dir name=\"deskbar\">
		\								<!-- provide a few entries in the main Deskbar menu, for testing the dyn/launcher -->
		\							<dir name=\"menu_entries\">
		\								<symlink name=\"top\"	target=\"/boot/system/bin/top\" />
#///ToDo: does not work yet, as symlink traversal is only done once, symlink-to-symlink is not traversed yet ; fix _that_, then I can re-enable _this_
#		\								<symlink name=\"top\"		target=\"/bin/top\" />  <!-- symlink to /boot/system/bin/top -->
		\								<symlink name=\"nano3d (raw)\"		target=\"/boot/apps/genode/nano3d\" />
		\								<symlink name=\"nano3d (packaged)\"	target=\"/boot/depot/genodelabs/pkg/nano3d/2023-04-25/runtime\" />
		\								<symlink name=\"GeDepot\"	target=\"/boot/apps/GeDepot\" />
		\								<symlink name=\"Pulse\"		target=\"/boot/apps/Pulse\" />
		\							</dir>
		\						</dir>
		\					</dir>
		\				</dir>
		\
		\				<!-- Mount FS with executables, for (client-side) vetting
		\					of /boot/system/bin/top, /boot/apps/genode/nano3d etc, before proceeding to (server-side) registrar
		\					launch request -->
#		\				<symlink  name=\"bin\"  target=\"/boot/system/bin\" />
		\				<dir name=\"boot\">
		\					<fs label=\"general\"/>
		\				</dir>
		"
		;
	Config_Route on hog-deskbar.run +=
		"
		\			<service name=\"File_system\" label=\"downstream\">
		\				<child name=\"vfs\"/>
		\			</service>
		\			<service name=\"File_system\" label=\"general\">
		\				<child name=\"vfs_ram\"/>
		\			</service>
		"
		;
	
	AddComponentAsStart  hog-deskbar.run : 3M :  # 2M   #///ToDo-2: increase vfs RAM a lot more(?) than 2M, as I'm confident there's no more big leak to exhibit, but still want to get an extra safety margin ?
		vfs : "name=\"vfs_ram\" caps=\"120\"" :
		"	<binary name=\"vfs\" />
		\	<provides> <service name=\"File_system\"/> </provides>
		\	<config ld_verbose=\"no\" >
		\		<vfs>
		\			<dir name=\"system\">
# NOTE: tweaked load_image() to strip "/boot" prefix...
# Alternative: put ALL the below (the pseudo ntfs) inside a <dir name=boot>, and
# 1) policy: pass root=/ to Deskbar et al
# 2) policy: pass root=/boot to fs_rom ..!
		\				<dir name=\"bin\">
		\					<rom name=\"top\"/>
		\				</dir>
		\			</dir>
		\			<dir name=\"apps\">
		\				<rom name=\"GeDepot\"/>
		\				<rom name=\"Pulse\"/>
		\				<dir name=\"genode\">
		\					<rom name=\"nano3d\"/>
		\				</dir>
		\			</dir>
		\			<dir name=\"depot\">
		\				<dir name=\"genodelabs\">
		\					<dir name=\"bin\">
		\						<dir name=\"x86_64\">
		\							<dir name=\"nano3d\">
		\								<dir name=\"2023-04-25\">
		\									<rom name=\"nano3d\" />
		\								</dir>
		\							</dir>
		\						</dir>
		\					</dir>
		\					<dir name=\"pkg\">
		\						<dir name=\"nano3d\">
		\							<dir name=\"2023-04-25\">
		\								<inline name=\"runtime\">
# this one is used client-side, by Roster.cpp :
\	<runtime ram=\"4M\" caps=\"200\" binary=\"nano3d\">
\		<requires> <gui/> <timer/> </requires>
\		<config/>
\		<content>
\			<rom label=\"ld.lib.so\"/>
\			<rom label=\"nano3d\"/>
\		</content>
\	</runtime>
		\								</inline>
		\							</dir>
		\						</dir>
		\					</dir>
		\				</dir>
		\			</dir>
		\		</vfs>
		\		<default-policy root=\"/\" writeable=\"yes\"/>
		\	</config>
		"
		;
}



if $(DESKBAR_DEPOT_Testing) || $(BUILD_DISTRO)
{
	AddRawComponent  hog-deskbar.run : cached_fs_rom : cached_fs_rom ;
	AddRawComponent  hog-deskbar.run : vfs_import.lib.so : vfs_import.lib.so ;
	
	AddComponentAsStart  hog-deskbar.run : 3M :
		vfs : "name=\"vfs_ram2\" caps=\"120\"" :
		"	<binary name=\"vfs\" />
		\	<provides> <service name=\"File_system\"/> </provides>
		\	<config ld_verbose=\"no\" >
		\		<vfs>
					# T-: ram:
					<ram/>
					# T+ of <ram>  node:
					# an 'inline' hardcoded repo index, for testing purposes:
					# (from test-depot_query/runtime):
		\			<import>
		\				<dir name=\"depot\">
		\					<dir name=\"genodelabs\">
		\						<inline name=\"download\">https://depot.genode.org</inline>
		\					</dir>
		\					<dir name=\"cnuke\">
		\						<inline name=\"download\">https://depot.genode.org</inline>
		\					</dir>
		\					<dir name=\"cproc\">
		\						<inline name=\"download\">https://depot.genode.org</inline>
		\					</dir>
		\				</dir>
		\				<dir name=\"public\">
							# initially empty
		\				</dir>
		\			</import>
		\			<dir name=\"depot\">
		\				<dir name=\"genodelabs\">
		\					<ram/>
#							<inline name=\"download\">https://depot.genode.org</inline>
					# To test without that pubkey, pass "verify=no" to depot_query et alia...
					#		<inline name=\"pubkey\">}   [depot_user_pubkey   genodelabs] {</inline>
							# depot_deploy: cached_fs_rom will access /genodelabs/bin/x86_64/nano3d/2023-04-25/nano3d
		\					<dir name=\"pkg\">
		\						<dir name=\"nano3d\">
		\							<dir name=\"2023-04-25\">
		\								<inline name=\"runtime\">
		\									<runtime ram=\"4M\" caps=\"200\" binary=\"nano3d\">
		\										<requires> <gui/> <timer/> </requires>
		\										<config/>
		\										<content>
		\											<rom label=\"ld.lib.so\"/>
		\											<rom label=\"nano3d\"/>
		\										</content>
		\									</runtime>
		\								</inline>
									#	<inline name=\"archives\">_/src/nano3d</inline>
		\								<inline name=\"archives\">genodelabs/src/nano3d/2023-04-25</inline>
		\							</dir>
		\						</dir>
		\					</dir>
		\					<dir name=\"bin\">  <!-- accessed by 1) depot_query, to elaborate a blueprint from 'archives' listing of exes/libs  2) by cached_fs_rom when actually running/launching nano3d -->
		\						<dir name=\"x86_64\">
		\							<dir name=\"nano3d\">
		\								<dir name=\"2023-04-25\">
		\									<rom name=\"nano3d\"/>
		\								</dir>
		\							</dir>
		\						</dir>
		\					</dir>
		\				</dir>
		\			</dir>
		\			<dir name=\"public\">
		\				<ram/>  <!-- This will contain downloaded .tar.xz files, before their verification/extraction to depot/ -->
		\			</dir>
		\		</vfs>
		\		<policy label=\"depot_download -> depot\"  root=\"/depot\"  writeable=\"yes\" />
		\		<policy label=\"depot_download -> public\" root=\"/public\" writeable=\"yes\" />
		\		<policy label=\"run_depot -> cached_fs_rom\"		root=\"/depot\" writeable=\"no\" />
		\		<policy label=\"run_depot -> depot_query -> depot\"	root=\"/depot\" writeable=\"no\" />
		\	</config>
		"
		;
	local	routing_server_for_depot		= "vfs_ram2" ;
	local	RunTarget_for_DepotDaemonInc	= "hog-deskbar.run" ;
	local	small_ram_quota_for_depot		= "true" ;
	include
		$(SUBDIR)/_geDepotDaemon.inc
		;
	
	AddNetworkingComponents hog-deskbar.run ;
}

AddPosixApp hog-deskbar.run : 25M : 305 : Deskbar ;
	# 305 caps is 'tight', a little too restrictive to test all features, but that also means
	# it's tight enough to see whether capabilities are being leaked (on menu opening e.g.).


#///TEMP:
AddPosixApp hog-deskbar.run : 26M : 325 : Sudoku ;
AddPosixApp hog-deskbar.run : 19M : 210 : DeskCalc ;
AddPosixApp hog-deskbar.run : 35M : 400 : FtpPositive ;

#AddPosixApp hog-deskbar.run : 35M : 300 : Icon-O-Matic ;
#AddRawComponent hog-deskbar.run : expat.lib.so : expat.lib.so ;  # expat is required by Icon-O-Matic (./tool/ports/prepare_port expat ; make -C ..... lib/expat)



# T++
#
if $(Deskbar_FULL_TEST) || $(BUILD_DISTRO)
{
	AddComponentClient   hog-deskbar.run
		: 27M
		: registrar
		: "
		\		<config ld_verbose=\"no\">
		\			<libc  rtc=\"/dev/rtc\" stdin=\"/dev/null\" stdout=\"/dev/log\" stderr=\"/dev/log\"/>
		\			<vfs>
	#///later: once TRoster::HandleAddApplication()'s B_ENTRY_NOT_FOUND test is re-enabled, registrar will need to have access to the <fs> in the general case, and to Deskbar as a ROM in the launch-bootmodule-at-bootup case
	#	\				<dir name=\"boot\">
	#	\					<fs label=\"general\"/>
	#	\				</dir>
				# Deskbar (launched as a boot-module) needs hardcoded access to its own binary, as it has no fs_rom access to it, unlike later launcher-launched apps.
	#	\				<rom name=\"Deskbar\"/>
		\				<dir name=\"dev\">
		\					<log/>
		\					<null/>
#+		\					<rtc />
		\					<fs label=\"downstream\"/>
		\				</dir>
		\			</vfs>
		\		</config>
		\	<route>
		\		<service name=\"Report\" label=\"system\">		<child name=\"platform_report_rom\"/> </service>
		\		<service name=\"Report\" label=\"dynit_config\">		<child name=\"dynit_report_rom\"/> </service>
		\		<service name=\"Report\" label=\"depotdeploy.config\">	<child name=\"dynit_report_rom\"/> </service>
		\		<service name=\"File_system\" label=\"downstream\">	<child name=\"vfs\"/>		</service>
	#	\		<service name=\"File_system\" label=\"general\">	<child name=\"vfs_ram\"/>	</service>
		\		<any-service> <parent/> <any-child/> </any-service>
		\	</route>
			"
			;

	# T++ :
	# Insert dynit at the *very end* of the config, as it gobbles up all/most of the remaining RAM
	AddDynitLauncher  hog-deskbar.run : vfs_ram : 50M ;
}


RunQemu
	hog-deskbar.run
	;

