# This jam file contains the common build routine for remote ports, it should
# not be used directly but rather 'included' by a recipe Jamfile, e.g. Vision/Jamfile


if ! $(list_src)
{
	Exit "*** Jam_generic.inc: don't call us directly, call the ('port') Jamfile which sets configuration variables and will in turn call us." ;
}


# -- Rule definitions : Download/extract/patch --

rule DownloadedArchive  destfile : url
{
	NotFile $(url) ;  # do not add a node for $(url) on the dependency graph
}

actions DownloadedArchive
{
	wget --quiet --output-document=$(1)  "$(2)"  # curl fails for some of the archives for some reason, let's use wget
	#  curl -o "$(1)"  "$(2)"  # or, to preserve the filename:  curl --remote-name  "$(2)"
}

rule ExtractedDir  dest_folder : source_archive
{
	Depends $(dest_folder) : $(source_archive) ;  # add a vertex on the dependency graph, between those two nodes
	
	if $(patch_set) {
		PatchedDir $(dest_folder) : $(patch_set) ;
	}
	
	RenameDir $(dest_folder) ;
}

actions ExtractedDir
{
	unzip -q $(2)  -d $(1).unpatched  # e.g.: unzip source.zip -d destdir.unpatched
		#///ToDo-2: switch $(source_archive:S).... case .zip, case .tgz etc
}

actions PatchedDir
{
	patch -p1 -d $(patch_root) < "$(2)"  # apply patch-file generated by e.g. "git diff -p --stat"
		# add -s for "silent/quiet" ?
}

actions RenameDir
{
	$(MV) $(1).unpatched $(1) ;  # e.g.:  mv -f destdir.unpatched destdir
}


# -- General setup --

# These must be set before loading Jamrules
HoG_TOP		?= ../../.. ;
LayerLevel	?= 7 ;
LOCATE_ToBuildFolder ?= "contrib_ports" ;  # instead of the default "bin-haiku_on_genode/" folder

# Load Jamrules, with definitions for...
#   * rule SetupHeadersHoG, rule Application, etc
#   * build configuration variables (so that we call gcc with flags "-fPIC -fno-builtin-sin" etc)
include $(HoG_TOP)/Jamrules ;

# Call this rule so that gcc will be called with...
#   -I"$GenodeRepos/libports/include/stdcxx"  (and other Genode and Genode contrib headers)
#   -I"../../../haiku-on-genode/kits/app"  (and other haiku headers)
SetupHeadersHoG ;


# -- App-specific setup, if any --
UsePrivateHeaders $(list_private_headers) ;

# -- Download/extract/patch/compile --
if $(dload_url)
{
	DownloadedArchive	source.zip	: $(dload_url) ;
	ExtractedDir		destdir		: source.zip ;
	
	Depends $(list_src) : destdir ;  # tell Jam to call 'ExtractedDir' before calling 'Application'
}
Application  $(app_name) : $(list_src) ;


# More config, for libs that don't have an .abi.so and get linked "as-is"...
# (this part of the script only works if located *below* the Application-rule call)
#
SEARCH on haiku.lib.so +=		$(HoG_TOP)/haiku-on-genode/system/kinda-kernel ;
SEARCH on avcodec.lib.so +=		$(GenodeBuild)/var/libcache/avcodec ;
SEARCH on avfilter.lib.so +=	$(GenodeBuild)/var/libcache/avfilter ;
SEARCH on avformat.lib.so +=	$(GenodeBuild)/var/libcache/avformat ;
SEARCH on avresample.lib.so +=	$(GenodeBuild)/var/libcache/avresample ;
SEARCH on avutil.lib.so +=		$(GenodeBuild)/var/libcache/avutil ;
SEARCH on swscale.lib.so +=		$(GenodeBuild)/var/libcache/swscale ;

