
#include <util/string.h>  // Genode::strlen() etc

#include <format/snprintf.h>

#include <sys/time.h>  // struct timeval

using Genode::size_t;


extern "C"
{

//int __stdinp = 0;
int __stdoutp = 0;
int __stderrp = 0;

// from listing over at
//https://git.haiku-os.org/haiku/plain/src/system/libroot/stubbed/libroot_stubs.c?id=defd975ae2fb70627c6da00a88f4bc9eb6509280

//void gettimeofday() {}
int gettimeofday(struct timeval * microseconds, struct timezone*)
{
///ToDo: gettimeofday() for ntfs..
	microseconds->tv_sec  = 0;
	microseconds->tv_usec = 0;
	return 0;
}

// this is used a couple times in libntfs-3g; one of them sometimes gets triggered when quitting AC
char * strerror( int err_no )
{
	// hackish, but probably doesn't matter:
	static char hackish_msg[64] = {};
	Format::snprintf( hackish_msg, sizeof(hackish_msg), "strerror code %d", err_no );
	
	return hackish_msg;
}

//void memcmp() {}
//xxx from libc.cc ...
int memcmp(void const *p1, void const *p2, size_t n)
{
	return Genode::memcmp(p1, p2, n);
}


void setlocale() {}


//void strchr() {}
//xxx from misc.cc ....:
char *strchr(const char *s, int c)
{
	while (*s != '\0') {
		if (*s == c)
			return (char*)s;
		s++;
	}

	if (c == '\0')
		return (char*)s;

	return nullptr;
}

/*
void strchrnul() {}
*/

//void strcmp() {}
int strcmp(const char * a, const char * b)
{
	return Genode::strcmp( a, b );
}

//void strlen() {}
//xxx from libc.cc ...:
size_t strlen(char const *s)
{
	return Genode::strlen(s);
}

//void strrchr() {}
//xx from libfdt_env.cc ... :
char *strrchr(const char *s, int c)
{
	char *save;
	char ch = c;

	for (save = nullptr;; ++s) {
		if (*s == ch)
			save = (char *)s;
		if (*s == '\0')
			return (save);
	}
	/* NOTREACHED */
	
	return nullptr;
}


}  // ~extern "C"

