/*
 * Copyright 2024, ttcoder
 * All rights reserved. Distributed under the terms of the MIT license.
 */
#ifndef fcntl_redirect2success_H
#define fcntl_redirect2success_H

/*
	In "mkntfs" context, unix_io.c makes calls like this:

		if (fcntl(DEV_FD(dev), F_SETLK, &flk))... return error...
	
	and bails out on failure, since Genode's fcntl() is a stub, which prevents
	the code from working. When used for the vfs_fuse_ntfs driver, we don't
	have a libc and thus could conceivably continue to define a custom fcntl()
	the way we did before, but now that we have this patch for mkntfs, might
	as well apply it retroactively to the vfs FUSE driver eh ? At any rate
	this patch is clearly needed for building *mkntfs*, since that one
	links against libc, and thus we need to redirect said calls away from
	the Genode libc fcntl() stub. We could patch the actual unix_io.c file, but
	we're not setup for patching, plus the following method seems more reliable:
	
	We use a macro to 'collapse' any call to fcntl() in that specific .c file
	into a mere return "0" (success). We cannot define the macro at the initial
	command-line level with something like...
		CC-FLAGS = -D\"fcntl(...)=(0)\""
	as that would trigger parsing errors in <fcntl.h>. We first have
	to #include <fcntl.h> un-touched, and _then_ we can redirect calls to
	fcntl() with a macro. The only way to do that seems to be, create this
	(fcntl_redirect2success.h) header do the job, and include it
	via CC-FLAGS "-include ..." directive, kinda over-riding
	unix_io's own #include directive.
*/


// T-
#include <fcntl.h>

// T+
#define fcntl(...) (0)


#endif // fcntl_redirect2success_H

