# Top Read-Me

## Project description

This set of components written in C++ augment Genode with componentized Haiku compatibility.
You may want to use a subset of them to extend Genode Labs's flagship Genode-based system (**SculptOS**) ;
or the whole set of them assembled in our own fledgling Genode-based system (called **"Haiku-on-genode"** for lack of a better name).
The desired end state is to have an extensively customized integration of the Genode framework which looks and feels like a hybrid of Haiku and Genode, combining the best of both worlds :
Genode's second-to-none stability/modularity/architecture (and later on, enabling its security features too), and Haiku's great end-user experience and developer API.

Similar to how Genode is an OS "framework", h-o-g could be said to be a "Be/Haiku repro framework", allowing you to
get more or less close to the Be/Haiku experience by combining more or less of the provided bits and pieces
with the existing (official) Genode building blocks.

See the wiki for [compilation directions](Setup:Main).


## Directory structure

The folder layout more or less follows the "one (top-ish) folder, one build unit" principle : bfs-on-genode delivers one 'driver', haiku-on-genode produces one library (haiku.lib.so), the _sub_folders inside misc-apps correspond to one application each.

Folder names denotate their license inherited from upstream (MIT or AGPL) and their dependancies
(some need to link against haiku.lib.so, some against Genode libraries, some need both).

Folders prefixed with **ge-** are forked from Genode's git repository (AGPL licensed),
e.g. the NTFS driver.

Folders prefixed with **hai-** contain code straight from Haiku's git repository (MIT licensed).
Most hai-* sources are 'verbatim' (unchanged), some are tweaked to be compatible with Genode,
e.g. the BWindow and BView classes target Genode's NitPicker rather than Haiku's app_server.

Folders prefixed with **hog-** and **misc-** contain custom code written from scratch (which we distribute under
the MIT license), for bridging the Haiku--Genode divide with stuff that cannot simply be "tweaked" on top of
the existing Genode and Haiku code, but has to be new code that 'breaks out' of the existing code bases.

Hence the (upcoming) folder layout -- "upcoming" because we're aiming at these, but some folders
still need to be cleaned-up and renamed to conform to this naming scheme, where noted:

- **build-jam** (currently named **jam**)
- `Jamrules`, `Jamfile` complement the build-jam/ folder to define the **build system** nuts & bolts ; depending on arguments one may build just the BFS driver, or haiku.lib.so, or test apps, or combine it all to create a bootable ISO image (together with an up-to-date Genode build) of our h-o-g operating system that can run Genode apps and Haiku apps side by side.
-	**ge-drivers**  : a 'fork' of Genode and Genode-world git repos, incl.:
	- ntfs-plus-xattr...  : Genode's NTFS-3g vfs plug-in, forked to add xattr support
		(**AGPL** license)
-	**ge-services**
		contains a 'fork' of Genode 24.02's driver_manager, as it has been retired in 24.04 (superceded by
		sculpt_manager) whereas we want to stick with it for now, until we can (?) use a "headless" sculpt_manager.
		(also, maybe to be done later): nitpicker-with-app_server-like-mods : Genode's nitpicker, forked to add some features ?
			(**AGPL license**)
-	**hai-lib (-so)**
		the all-in-one **haiku.lib.so** library agregating all Haiku libraries normally found in e.g. hai-src/kits : libbe.so, libroot.so, libmedia.so, libtranslation.so, libtracker.so and so on.
	-	kits/
	-	shadow-kernel/ aka kinda-kernel/ or haiku-emul/: it's tempting to take a hint from Genode's "lx_emul" terminology
and use the wording "haiku-emul" (or shadow_kernel as per [this post](http://genodians.org/nfeske/2021-09-03-pine-fun-networking) )
-	**hai-ports**: apps imported from e.g. HaikuArchives via haikuports etc
-	**hai-apps** or **hai-src** (aka hai-base or hai-kits or hai-library)  # a (mostly-Unforked) mirror of https://git.haiku-os.org/haiku/tree/src
	-	apps : Contains a selection of standard Haiku apps and **demo apps**, a good introduction on running Haiku code on top of Genode thanks to haiku.lib.so (the more demanding apps also require Broker, the BFS driver, and other components).
		- bemail, pulse... ?
		- deskbar
		- tracker
	- bin
		- addattr
		- alert ..
	- data ?
	- preferences
		- appearance, backgrounds ?
	- server
		- registrar
		- mail daemon ?  notification, package, print ?
	->	Contains most of the **apps**, preflets, servers/daemons which are carried over
		from Haiku to Haiku-on-Genode, **except haiku.lib.so** (kits/ subfolder) which has
		its own "hai-lib" folder, above.
-	**hai-drivers** or maybe **hai-sys-drv**  # Haiku drivers, converted for Genode
	-	bfs-fuse (check license : mixed ? belongs to a ge- folder or a hai- folder ?)
	-	bfs-on-genode/ is a **BFS** (BeOS/Haiku **File System**) driver for Genode 18.11 (shortcomings: Genode 20.x support is lacking, need to work on it to bring it up from plain-FUSe to vfs-FUSe)
-	**hog-apps** : apps designed specifically for h-o-g, i.e. which utilize both Be and Genode APIs:
	-	GeDepot (for downloading, installing, and running apps from depot.genode.org)
-	**hog-lib** : some debug etc shared code (LeakChecker, tracing...)
-	**hog-services** or **misc-services**
		These have few or no dependancies on haiku.lib.so (so they could conceivably run on other Genode-based systems,
		though their usefulness would be limited there).
	- **broker** (IPC support for write_port() API)
	- **indexer** (support for BFS-like indexing and query system, when paired with even non-BFS file systems, so long as they have xattr support, e.g. : BFS, NTFS, etc)
-	**hog-tests** (currently: <code>misc-tests/</code>) (quick & efficient test scenarios for daily HoG development)
minimal harness code, not a substitute for extensive pre-production testing, but crucial for short turn-around time during development.


## Diagram : comparing HoG vs. upstream Haiku

As to the "Big Picture" (big pikchr ? :g:) comparing Haiku and Genode and explaining the motivation
for "restacking" Haiku, here's a simplified view of how it all stacks up.

~~~ pikchr
lineht *= 0.4
down
$margin = lineht*6
$red    = 0xf55555 ; $pink   = 0xf8c8c0
$yellow = 0xd5d535
$cyan   = 0xa5a5ff
$blue   = 0x8e7efe
$purple = 0xad5efe
$gray   = 0xd0d0d0
$misc = 0xd8fcc0

text "Haiku"
HKern:  box "kernel_intel" fit wid 420%

Hhda:  box with .nw at sw of HKern  "HDA driver" fill $red
right
move 20%
Hahci:  box "AHCI driver" fill $red
move 20%
Hvesa:  box "Vesa driver" fill $red
move 20%
Hnet:   box "TCP/IP etc" fill $red

down
  box with .n at south of Hhda "media_server" "+ Media Kit" fill $yellow

HBFS:   box with .n at south of Hahci "bfs"  fill $red
Hvfs:   box "vfs"  fill $red
  box "libroot.so" fill $gray thick

Happsrv: box with .n at south of Hvesa "app_server" fill $yellow
  box "libbe.so" fill $gray thick
  box "registrar"
  box "Deskbar, Tracker"
  box "AutoCast, MMD," "AK, L'ning, etc"

Hnetserv: box with .n at south of Hnet  "net_server"  fill $red

# ----------------------

HOG:  text same with .w at 3*$margin east of 1st text.e  "Haiku on Genode"
GKern:  box "Nova Microkernel" fit wid 290%

Ghda:  box with .nw at sw of GKern  "pci_audio" "(OpenBSD)" fill $blue
right
move 20%
Gahci:  box "ahci" fill $blue
move 20%
Gvesa:  box "vesa_fb" fill $blue
move 20%
Gnet:   box "TCP/IP: lxip" "(Linux)" fill $blue

down

       box with .n at south of Ghda  "mixer" "+ libav"  fill $blue

GBFS:   box with .n at south of Gahci  "ntfs" "+ bfs"  fill $cyan
GVFS:   box  "vfs"  fill $blue
# move to right of GVFS
box "indexer" "(ttcoder)"  fill $purple
box "libc.lib.so" "(FreeBSD)"  fill $blue
box "broker"  "(ttcoder)"  fill $purple
box "libroot-HiG" "(Haiku, ttcoder)"  fill $misc thick

Gnp:    box with .n at south of Gvesa  "nitpicker"  fill $blue
box "libbe-HiG" "(Haiku, ttcoder)"  fill $misc thick
box "registrar"
box "Deskbar, Tracker"
box "AutoCast, MMD," "AK, L'ning, etc"

Gnetserv: box with .n at south of Gnet  "nic"  fill $blue
box  "nic_router"  fill $blue
~~~

How to read that diagram:

- components that are 'foreign' to either project (originate neither from within Haiku nor Genode), have their origin noted in brackets, e.g. "(Linux)"
- colors denotate kernel-land vs. user-space: Haiku has a "sea of red" (dozens of components mixed together
in the same kernel space without any protection whatsoever between them), Genode has no kernel-space mix-ups at all,
the only kernel-space component is NOVA, everything else is in blue (user-space).
- yellow color denotates Haiku components that live in user-space, but still have trouble recovering from crashes,
vs. their Genode equivalents, whose path to recovery is easier to define.
- white indicates no change ; for instance, 'registrar' is compiled more or less the same on Haiku and on Genode
	(on Genode it needs a few adjustements to its build Jamfile), same for TTS AutoCast, Deskbar, and so on.
- Haiku code that was customized to become "glue" between Haiku and Genode is colored green-ish, with thick borders.


